cls
clear

**set the folder directory to your computer settings
global folder "Your_folder\Stata_package_for_JMCB"  
cd $folder

** controls
global controls 			   L_cet1_buffer L_lr_buffer L_TLAC L_NPL_ratio L_CSH_to_A L_DEP_to_L  L_density 
global stagger 			  	     cet1_buffer   lr_buffer   TLAC   NPL_ratio   CSH_to_A   DEP_to_L    density c2y_gap 
global mtch_prd    				 cet1_buffer   lr_buffer   TLAC   NPL_ratio   CSH_to_A   DEP_to_L    density ROA
global covid_cntrl               cet1_buffer   lr_buffer   TLAC   NPL_ratio   DEP_to_L    density 
di "$controls"

********************************************************************************
** Table 1: Summary statistics of main variables
********************************************************************************
use "$folder\data_RR_MASTER_public", replace
replace near = . if year<=2013 
replace near = . if gsib_score==.
eststo clear
estpost tabstat gsib_score_ofcl gsib_score_nrm2 near ///
ROA CET1_ratio cet1_buffer C_ratio C_ratio_buffer LEVR lr_buffer TLAC density NPL_ratio CSH_to_A DEP_to_L c2y_gap, ///
statistics(mean sd p10 p25 p50 p75 p90 count) columns(statistics)
esttab . using "$folder\exhibits\T1_sum_stat", tex ///
cell((mean(fmt(2)) sd(fmt(2)) p10(fmt(2)) p25(fmt(2)) p50(fmt(2)) p75(fmt(2)) p90(fmt(2)) count(fmt(0)))) ///
collabels("Mean" "Stdev" "P10" "P25" "P50" "P75" "P90" "N") ///
replace label nonumber noobs

********************************************************************************
** Figure 2: G-SIB score evolution by ROA and scatter plot
********************************************************************************
**** left panel (line plot)
cls
clear
use "$folder\data_RR_MASTER_public", replace
label variable ROA "Return on assets: ROA (%)"
keep if always_mpg == 1
keep id year bank_type gsib_score post_2015
drop if bank_type == ""
collapse (mean) gsib_score, by(bank_type year)
sort bank_type year

twoway line gsib_score year if bank_type == "Low ROA Non GSIB", xline(2015, lpattern(dash) lcolor(red)) yaxis(1) lcolor(cyan) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score year if bank_type == "High ROA Non GSIB", yaxis(1) lcolor(navy)  lpattern(dash_dot) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score year if bank_type == "High ROA GSIB", lcolor(cranberry) yaxis(2) lpattern(dash) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2)) || ///
line gsib_score year if bank_type == "Low ROA GSIB", lcolor(sand) yaxis(2) lwidth(*2) lpattern(dot) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2))  ///
legend(order(3 "High ROA G-SIBs (rhs)" 1 "Low ROA Non G-SIBs (lhs)" 4 "Low ROA G-SIBs (rhs)" 2 "High ROA Non G-SIBs (lhs)" ) symxsize(*0.9) rows(2) pos(6) colgap(20) region(lcolor(white)) size(4)) ///
graphregion(color(white)) name(line_DDD, replace) ysize(3) xsize(4) xtitle("") ytitle(Average score: Non G-SIBs, height(8) axis(1) size(4)) ///
ytitle(Average score: G-SIBs, height(10) axis(2) size(4)) ///
text(100 2013.7 "Pre-treatment", color(black) size(4)) ///
text(90 2013.4 "period", color(black) size(4))  
graph export "$folder\exhibits\F2_ddd_line.jpg", replace
graph export "$folder\exhibits\F2_ddd_line.pdf", replace
 

**** right panel (scatter plot)
cls
clear
use "$folder\data_RR_MASTER_public", replace
label variable ROA "Return on assets: ROA (%)"
scatter ROA gsib_score, mcolor(gs12) msymbol(square) name(gsib_score, replace) graphregion(color(white)) ///
xline(130, lcolor(green)) yline(0.92, lcolor(green)) ///
text(3.3 60 "High ROA", color(black) size(4)) ///
text(3 60 "Non G-SIBs", color(black) size(4)) ///
text(3.3 300 "High ROA", color(black) size(4)) ///
text(3 300 "G-SIBs", color(black) size(4)) ///
text(-0.2 60 "Low ROA", color(black) size(4)) ///
text(-0.5 60 "Non G-SIBs", color(black) size(4)) ///
text(-0.2 300 "Low ROA", color(black) size(4)) ///
text(-0.5 300 "G-SIBs", color(black) size(4)) ///
ysize(3) xsize(4) || ///
scatter ROA gsib_score if gsib_forever==1 & year==2013, mcolor(red) msymbol(triangle) || ///
scatter ROA gsib_score if gsib_forever==1 & year==2014, mcolor(red) msymbol(triangle) || ///
scatter ROA gsib_score if gsib_forever==0 & year==2013, mcolor(blue) || /// 
scatter ROA gsib_score if gsib_forever==0 & year==2014, mcolor(blue)  /// 
legend(order(1 "All banks" 3 "G-SIBs (pre-2015)"  4 "Non G-SIBs (pre-2015)") pos(6) rows(1) region(lwidth(none)) size(4)) ///
ytitle("ROA (%)", size(4) height(6)) xtitle("G-SIB score", size(4) height(6))
graph export "$folder\exhibits\F2_gsib_score_by_ROA.jpg",  replace
graph export "$folder\exhibits\F2_gsib_score_by_ROA.pdf",  replace

********************************************************************************
** Figure 3: Change in G-SIB score by the four groups (bar plot)
********************************************************************************
use "$folder\data_RR_MASTER_public", replace
keep if always_mpg == 1
keep id year bank_type gsib_score post_2015
drop if bank_type == ""
collapse (mean) gsib_score, by(bank_type post_2015)
sort bank_type post_2015

encode(bank_type), gen(id)
xtset id post_2015 
gen change = gsib_score - L.gsib_score
keep if post_2015 == 1
gsort -change

graph bar change, over(bank_type, sort(1) descending) asyvars bargap(50) ///
bar(1,color(cranberry) lwidth(*0.001) ) ///
bar(2,color(navy) lwidth(*0.001)  ) ///
bar(3,color(sand) lwidth(*0.001)) ///
bar(4,color(cyan) lwidth(*0.001)) ///
graphregion(color(white)) legend(order(2 "High ROA" "Non G-SIBs" 1 "High ROA" "G-SIBs"  4 "Low ROA" "Non G-SIBs" 3 "Low ROA" "G-SIBs") symxsize(*0) colgap(*3) rows(1) pos(6) region(lwidth(none))) name(line_DDD_bar, replace) blabel(bank_type) ysize(3) xsize(5) ytitle("") ///
ytitle("Change in average score:" "Post- minus pre-treatment", height(10))
graph export "$folder\exhibits\F3_ddd_bar.jpg", replace
graph export "$folder\exhibits\F3_ddd_bar.pdf", replace

** check if the changes are significant
use "$folder\data_RR_MASTER_public", replace
keep if always_mpg == 1
keep id year bank_type gsib_score post_2015
collapse (mean) gsib_score, by(id post_2015 bank_type)
xtset id post_2015
gen change = gsib_score - L.gsib_score
keep if !missing(change) 
by bank_type, sort: ttest change == 0

********************************************************************************
** Table 2: Baseline difference-in-differences (DD) results
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace

eststo clear
global output_filename "$folder\exhibits\T2_dd"

eststo: reghdfe gsib_score i.post##i.gsib, noabsorb vce(cluster id)
estadd local cls Bank-level
estadd local bank_cn No
estadd local ct_fe No
estadd local score Adjusted

eststo: reghdfe gsib_score_ofcl i.post##i.gsib, noabsorb vce(cluster id)
estadd local cls Bank-level
estadd local bank_cn No
estadd local ct_fe No
estadd local score Official

eststo: reghdfe gsib_score i.post##i.gsib $controls L_ROA, absorb(i.id) vce(cluster id) 
estadd local cls Bank-level
estadd local bank_cn Yes
estadd local ct_fe No
estadd local score Adjusted

eststo: reghdfe gsib_score i.post##i.gsib $controls L_ROA, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local cls Bank-level
estadd local bank_cn Yes
estadd local ct_fe Yes
estadd local score Adjusted

esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels ///
order(1.post#1.gsib 1.post 1.gsib $controls) star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe score, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "G-SIB score" )) nomtitle


********************************************************************************
** Table 3: Sub-sample difference-in-differences on high ROA and low ROA G-SIBs
********************************************************************************
cls
clear
eststo clear
use "$folder\data_RR_MASTER_public", replace
global output_filename "$folder\exhibits\T3_dd_low_roa"

**** low ROA G-SIBs vs all Non-G-SIBs
preserve
keep if ((gsib_forever == 0) | (gsib_forever == 1 & ROA_med == 0))
eststo: reghdfe gsib_score i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Adjusted
eststo: reghdfe gsib_score_ofcl  i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Official
eststo: reghdfe gsib_score i.post##i.gsib $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_cn Yes
estadd local ct_fe Yes
estadd local score Adjusted
restore

**** low ROA G-SIBs vs low ROA Non-G-SIBs
preserve
keep if ROA_med == 0
eststo: reghdfe gsib_score i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Adjusted
eststo: reghdfe gsib_score_ofcl  i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Official
eststo: reghdfe gsib_score i.post##i.gsib $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_cn Yes
estadd local ct_fe Yes
estadd local score Adjusted
restore

esttab using $output_filename, tex lines label nogaps nonotes replace nocons noomitted nobaselevels ///
drop($controls _cons) ///
order(1.post#1.gsib) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe score, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Score" )) ///
nomtitles mgroups("\shortstack{\textbf{Panel A}\\ \\ Low ROA G-SIBs vs \\ All Non G-SIBs}" "\shortstack{\textbf{Panel B}\\ \\ Low ROA G-SIBs vs \\ Low ROA Non G-SIBs}", pattern(1 0 0 1 0 0) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

cls
clear
eststo clear
use "$folder\data_RR_MASTER_public", replace
global output_filename "$folder\exhibits\T3_dd_high_roa"

**** high ROA G-SIBs vs all Non-G-SIBs
preserve
keep if ((gsib_forever == 0) | (gsib_forever == 1 & ROA_med == 1))
eststo: reghdfe gsib_score i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Adjusted
eststo: reghdfe gsib_score_ofcl  i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Official
eststo: reghdfe gsib_score i.post##i.gsib $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_cn Yes
estadd local ct_fe Yes
estadd local score Adjusted
restore

**** low ROA G-SIBs vs high ROA Non-G-SIBs
preserve
keep if ROA_med == 1
eststo: reghdfe gsib_score i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Adjusted
eststo: reghdfe gsib_score_ofcl  i.post##i.gsib, noabsorb vce(cluster id) 
estadd local bank_cn No
estadd local ct_fe No
estadd local score Official
eststo: reghdfe gsib_score i.post##i.gsib $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_cn Yes
estadd local ct_fe Yes
estadd local score Adjusted
restore 

esttab using $output_filename, tex lines label nogaps nonotes replace nocons noomitted nobaselevels ///
drop($controls _cons) ///
order(1.post#1.gsib) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe score, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Score" )) ///
nomtitles mgroups("\shortstack{\textbf{Panel C}\\ \\ High ROA G-SIBs vs \\ All Non G-SIBs}" "\shortstack{\textbf{Panel D}\\ \\ High ROA G-SIBs vs \\ High ROA Non G-SIBs}", pattern(1 0 0 1 0 0) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

********************************************************************************
** Table 4. Triple interaction regression results
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
eststo clear
global output_filename "$folder\exhibits\T4_ddd"
replace dummy = pre_ROA_continuous

eststo: reghdfe gsib_score i.post##i.gsib##c.dummy, noabsorb vce(cluster id) 
estadd local ct_fe No
estadd local bank_cn No
estadd local score Adjusted
estadd local roa Level
estadd local matching No
estadd local rdd No

eststo: reghdfe gsib_score_ofcl i.post##i.gsib##c.dummy, noabsorb vce(cluster id) 
estadd local ct_fe No
estadd local bank_cn No
estadd local score Official
estadd local roa Level
estadd local matching No
estadd local rdd No

eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level
estadd local matching No
estadd local rdd No

replace dummy = ROA_med
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Dummy
estadd local matching No
estadd local rdd No

**Table with DDD results
esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels  ///
drop(_cons $controls) ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib 1.post#c.dummy 1.post#1.gsib 1.gsib#c.dummy 1.post 1.gsib) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe score roa, ///
labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Score" "ROA measure" "Matching" "Banks close to G-SIB threshold"))  

********************************************************************************
** Table 5. Triple interaction regression results: robustness checks
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace

************************************
* Matching 
************************************

* Estimate weights, at the end of this process, just a weight variable must be added to the dataset)
sort id year
xtset id year
* we will match firms only based on pre-treatment characteristics 
drop if post==1
* match based on controls used in the baseline DD -- use average value of controls in the pre-treatment period
collapse (mean) $mtch_prd cc_num gsib_pre ROA_med, by(id) 
* matching covariates - pre-treatment average & standardize for matching
foreach v of varlist $mtch_prd {
egen `v'_st = std(`v')
drop  `v'
rename `v'_st `v'
}

************************************** matching method 1
logit gsib_pre $mtch_prd 
predict propscore1
* Kernel matching 
gen weight1 = .
psmatch2  gsib_pre , kernel pscore(propscore1) com cal(0.05) /*com imposes common support for propscore*/
replace weight1 = _weight if weight1 == .
pstest $mtch_prd , both 
drop _treated _support _pscore _weight prop*

************************************** matching method 2 
* exact matching low vs high ROA banks
egen exactmatch = group(ROA_med) 
logit gsib_pre $mtch_prd if exactmatch==1
predict propscore2
logit gsib_pre $mtch_prd if exactmatch==2
predict propscore2b
replace propscore2 = propscore2b if propscore2==.
drop propscore2b
*Kernel matching combined with exact matching on ROA_med
gen weight2 = .
levelsof exactmatch, local(gr)
foreach j of local gr {
            psmatch2 gsib_pre if exactmatch == `j', kernel pscore(propscore2) com cal(0.05) 
			/*com imposes common support for propscore*/
            replace weight2 = _weight if weight2 == . 
}
pstest $mtch_prd , both
**manually add the p-values to Annex Table A5.
global pv_cet1_buffer = 0.22
global pv_lr_buffer   = 0.55
global pv_NPL_ratio   = 0.66
global pv_CSH_to_A    = 0.98
global pv_DEP_to_L    = 0.13
global pv_density     = 0.49
global pv_TLAC        = 0.93
global pv_ROA         = 0.81

drop _treated _support _pscore _weight prop* exactmatch

* merge with main data
keep id weight*
save $folder\temp\matching_weights, replace
use "$folder\data_RR_MASTER_public", replace
merge m:1 id using $folder\temp\matching_weights
drop _merge
save "$folder\temp\data_matching", replace


********** back to running the regressions, 2 columns on matching 
eststo clear
global output_filename "$folder\exhibits\T5_ddd_robust"
replace dummy = pre_ROA_continuous

foreach v of varlist weight* {
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls [aweight = `v'] , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level
estadd local matching Yes
estadd local rdd No
estadd local dsib In
estadd local trt_year 2015 
}

************************************
* RDD - regression sample restricted to only those banks whose average official score
* in the pre-treatment period is within 100 bps of the 130 bps threshold that determines
* whether a bank is a G-SIB.
************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
** keep banks in local area of 130 bps based on average pre-treatment score official
preserve
keep year id gsib_score_ofcl
keep if year >= 2013 & year <= 2014
collapse (mean) gsib_score_ofcl, by(id)
rename gsib_score_ofcl pre_trt_ofcl_gsib_score
gen rdd_ind = 0
replace rdd_ind = 1 if pre_trt_ofcl_gsib_score >= 30 & pre_trt_ofcl_gsib_score <= 230
tab rdd_ind
save "$folder\temp\rdd", replace
restore
merge m:1 id using "$folder\temp\rdd"
drop _merge

replace dummy = pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls if rdd_ind == 1, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level
estadd local matching No
estadd local rdd Yes
estadd local dsib In
estadd local trt_year 2015 

************************************
* Proxy G-SIB score from 2010 to 2018 using quarterly data  // proxy CET1 buffer and LR buffer given data constraints
************************************
use "$folder\data_RR_PTH_public", replace
drop gsib dummy
gen gsib = gsib_forever 
gen dummy = pre_ROA_continuous
label variable A_2013 "G-SIB score"
eststo: reghdfe A_2013 i.post##i.gsib##c.dummy $controls , absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Proxy
estadd local roa Level
estadd local matching No
estadd local rdd No
estadd local dsib In
estadd local trt_year 2015

***************************************
*** Drop Non-G-SIBs s.t. D-SIB surcharges
***************************************

cls
clear
use "$folder\data_RR_MASTER_public", replace
replace dummy = pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls if dsib_flag!=1, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level
estadd local matching No
estadd local rdd No
estadd local dsib Drop
estadd local trt_year 2015 

************************************
*** Set treatment date to >=2016 
************************************

cls
clear
use "$folder\data_RR_MASTER_public", replace
replace post = year>=2016
replace dummy = pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level
estadd local matching No
estadd local rdd No
estadd local dsib In
estadd local trt_year 2016 

esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels  ///
drop(_cons $controls) ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib 1.post#c.dummy 1.post#1.gsib) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe score roa matching rdd dsib trt_year, ///
labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Score" "ROA measure" "Matching" "Banks close to G-SIB threshold" "D-SIBs" "Treatment year"))  

**********************************************************************************
** Figure 4: Assessing the evolution of the impact of the framework over the years
**********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
replace dummy = pre_ROA_continuous
reghdfe gsib_score i.year##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estimates store DDD_time_cont
foreach v in DDD_time_cont {
	coefplot (`v', keep(*.year#1.gsib#c.dummy)), ///
	ylabel(-10(10)60) yscale(range(-10(10)60)) vertical yline(0, lcolor(blue)) xline(3, lpattern(dash)) ///
	msymbol(d) mcolor(red)    ///
	levels(95 90) ciopts(lwidth(3 ..) lcolor(*.2 *1)) ///
	legend(order(1 "95" 2 "90") pos(6) rows(1)) ///
	order(2013.year#1.gsib#c.* ///
	2014.year#1.gsib#c.* ///
	2015.year#1.gsib#c.* ///
	2016.year#1.gsib#c.* ///
	2017.year#1.gsib#c.* ///
	2018.year#1.gsib#c.*) ///
	coeflabel( ///
	2013.year#1.gsib#c.* = "2013" ///
	2014.year#1.gsib#c.* = "2014" ///
	2015.year#1.gsib#c.* = "2015" ///
	2016.year#1.gsib#c.* = "2016" ///
	2017.year#1.gsib#c.* = "2017" ///
	2018.year#1.gsib#c.* = "2018") ///
	name(`v', replace) graphregion(color(white)) omitted baselevels recast(connected) ysize(2) xsize(3)
	graph export $folder\exhibits\F4_ddd_time_dummy.jpg, replace
	graph export $folder\exhibits\F4_ddd_time_dummy.pdf, replace
}

********************************************************************************
** Table 6: Assessing the role of proximity to G-SIB bucket thresholds
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
eststo clear
global output_filename "$folder\exhibits\T6_proximity"
tsset id year

replace near=0 if year==2013 
replace near=. if gsib_score_ofcl==.
replace dummy = pre_ROA_continuous
gen L_near = L.near
label variable L_near "Close to bucket threshold"

**Simple close vs not-close
eststo: reghdfe gsib_score c.L_near $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

**Only low ROA banks
eststo: reghdfe gsib_score c.L_near $controls if ROA_med==0 , absorb(i.id i.year#i.cc_num) vce(cluster id)
estadd local bank_fe Yes
estadd local ct_fe Yes

**Only high ROA banks
eststo: reghdfe gsib_score c.L_near $controls if ROA_med==1 , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

**All banks, split "close" effect by continuous ROA 
eststo: reghdfe gsib_score c.L_near##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local roa Continuous

**All banks, split "close" effect by ROA dummy
replace dummy = ROA_med
eststo: reghdfe gsib_score c.L_near##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local roa Dummy

esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels drop(_cons $controls) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_fe ct_fe roa, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Profitability")) ///
nomtitles mgroups("\shortstack{All banks}" "\shortstack{Low ROA banks}" "\shortstack{High ROA banks}" "\shortstack{All banks}" "\shortstack{All banks}" , pattern(1 1 1 1 1 ) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

*****************************************************************************************
** Figure 5: Impact of the G-SIB framework when considering bank-specific treatment dates
*****************************************************************************************

foreach v in 0 1 {
	cls
	clear
	eststo clear
	use "$folder\data_RR_MASTER_public", replace
	sort id year
	// we need a new treatment yr, which is 0 for NON gsibs (never treated) and = yr treated in for the GSIBs
	by id: gen bank_specific_treatment = treated_in
	by id: replace bank_specific_treatment = 0 if gsib_pre==0
	* run csdid 
	csdid gsib_score $stagger if (ROA_med == `v'), ivar(id) time(year) gvar(bank_specific_treatment) level(95) method(reg) saverif(roa_`v'_rif) replace agg(event) wboot seed(1601) pointwise
	use roa_`v'_rif, clear
	csdid_stats event, wboot seed(1601) pointwise
	* import into excel 
	mat list r(table) // investigate
	mat roa_`v' = r(table)'
	putexcel set "$folder\temp\roa_`v'.xlsx", sheet("roa_`v'") modify // remember to specify the full path
	putexcel A1 = matrix(roa_`v')
	import excel "$folder\temp\roa_`v'.xlsx", sheet("roa_`v'") clear
	keep A E F 
	keep if _n >= 3 & _n <= 8 
	rename A b
	rename E ll
	rename F ul
	gen dates = _n - 3
	save "$folder\temp\roa_`v'", replace
	graph twoway (rbar ll ul dates, barwidth(.1) color(gs13)) (connected b dates, msymbol(d) mcolor(red) lc(navy)) , yline(0, lcolor(blue))  ysc(r(-60(20)60)) ylabel(-60(20)60) xline(0, 	lpattern(dash)) graphregion(color(white) lwidth(large)) xtitle("Periods to treatment") ytitle("ATT") legend(label(1 95% CI) label(2 Coefficient) pos(6) rows(1) region(lstyle(none))) name(roa_`v'_edited, replace)
	graph export "$folder\exhibits\F5_csdid_roa_`v'.jpg", replace
	graph export "$folder\exhibits\F5_csdid_roa_`v'.pdf", replace
	erase roa_`v'_rif.dta
}

********************************************************************************
** Table 7: Profitability versus bank capitalisation: a horse-race
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
eststo clear
xtset id year, yearly
replace dummy = pre_ROA_continuous

** First construct pre-treatment averages 
foreach var of varlist CET1_ratio cet1_buffer C_ratio C_ratio_buffer density NPL_ratio CSH_to_A {
bysort id : egen tmp_`var' = mean(`var') if year < 2015
bysort id : egen avg_`var' = mean(tmp_`var') 
egen cutoff_`var' = pctile(avg_`var'), p(50)
gen `var'_med = 0 if  avg_`var' != .
replace `var'_med = 1 if  avg_`var' != . & avg_`var' >= cutoff_`var'
drop tmp_`var'
rename cutoff_`var' `var'_med_cutoff
rename avg_`var' pre_`var'_continuous
}


** Now do two-by-two triple interactions of (a) profit (b) bal sheet var
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level

**CET1 ratio
gen cap = pre_CET1_ratio_continuous
label variable cap "Balance sheet variable"
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level

**CET1 buffer
replace cap = pre_cet1_buffer_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level

*Total capital ratio
replace cap = pre_C_ratio_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level

*Total capital ratio buffer
replace cap = pre_C_ratio_buffer_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local ct_fe Yes
estadd local bank_cn Yes
estadd local score Adjusted
estadd local roa Level


global output_filename "$folder\exhibits\T7_horse"
esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels  ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib#c.cap    ) ///
keep(1.post#1.gsib#c.dummy 1.post#1.gsib#c.cap    ) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_cn ct_fe, ///
labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "Score" "ROA measure")) /// 
nomtitles mgroups("Baseline" "\shortstack{CET1 capital \\ratio}" "\shortstack{CET1 capital\\ buffer}" "\shortstack{Total capital \\ratio}" "\shortstack{Total capital \\buffer}" "\shortstack{Density\\ratio}", pattern(1 1 1 1 1 1))

** Quick check with density NPL and CSH/A for a footnote in the main text
global output_filename "$folder\exhibits\T7_horse_footnote"
eststo clear
replace cap = pre_density_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
replace cap = pre_NPL_ratio_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
replace cap = pre_CSH_to_A_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.post##i.gsib##c.cap $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels  ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib#c.cap    ) ///
keep(1.post#1.gsib#c.dummy 1.post#1.gsib#c.cap    ) ///
star(* 0.10 ** 0.05 *** 0.01)

********************************************************************************
** Table 8: Systemic risk during the pandemic
********************************************************************************
clear 
cls
eststo clear
**Load the dataset (cross sectin with year==2019)
use "$folder\data_RR_MAIN_COVID_public", replace
tabstat srisk_start if gsib==1 & ROA_med==1, statistics(mean q co)

**Regressions
**ROA dummy, no controls, cluster by country
replace dummy = ROA_med

eststo: reg srisk_DPeak i.gg , cluster(cc_num)
test 3.gg=4.gg
estadd local diff = round((_b[4.gg] - _b[3.gg]),0.001)
estadd local tt = round(r(p),.001)
estadd local ft = round(r(F),.001)
estadd local lhs SRISK
estadd local roa Dummy
estadd local clust Country
estadd local bank_cn No

**ROA dummy, add controls, cluster by country
eststo: reg srisk_DPeak i.gg $covid_cntrl , cluster(cc_num)
test 3.gg=4.gg
estadd local diff = round((_b[4.gg] - _b[3.gg]),0.001)
estadd local tt = round(r(p),.001)
estadd local ft = round(r(F),.001)
estadd local lhs SRISK
estadd local roa Dummy
estadd local clust Country
estadd local bank_cn Yes

eststo: reg srisk_PeakRel_w i.gg $covid_cntrl , cluster(cc_num)
test 3.gg=4.gg
estadd local diff = round((_b[4.gg] - _b[3.gg]),0.001)
estadd local tt = round(r(p),.001)
estadd local ft = round(r(F),.001)
estadd local lhs SRISK (rel change)
estadd local roa Dummy
estadd local clust Country
estadd local bank_cn Yes

eststo: reg sriskm_DPeak i.gg $covid_cntrl , cluster(cc_num)
test 3.gg=4.gg
estadd local diff = round((_b[4.gg] - _b[3.gg]),0.001)
estadd local tt = round(r(p),.001)
estadd local ft = round(r(F),.001)
estadd local lhs SRISK (USD bn)
estadd local roa Dummy
estadd local clust Country
estadd local bank_cn Yes

eststo: reg sriskm_PeakLN20 i.gg $covid_cntrl , cluster(cc_num)
qui test 3.gg=4.gg
estadd local diff = round((_b[4.gg] - _b[3.gg]),0.001)
estadd local tt = round(r(p),.001)
estadd local ft = round(r(F),.001)
estadd local lhs SRISK (log change)
estadd local roa Dummy
estadd local clust Country
estadd local bank_cn Yes

global output_filename "$folder\exhibits\T8_srisk"
esttab using $output_filename, tex label nogaps lines nonotes replace noomitted drop(1.gg $covid_cntrl _cons) nocons ///
star(* 0.10 ** 0.05 *** 0.01)  b(2) ///
stats(N r2_a bank_cn diff tt ft, labels("N" "R2" "Bank controls" "Difference High vs Low ROA GSIBs" "P-value" "F-stat")) nomtitle mgroups("\shortstack{$\Delta$ SRISK \% \\}" "\shortstack{$\Delta$ SRISK \% \\}" "\shortstack{$\Delta$ SRISK \% \\ relative changes}" "\shortstack{$\Delta$ SRISK \\ US billion}" "\shortstack{$\Delta$ SRISK \\ log changes}", pattern(1 1 1 1 1))

********************************************************************************
** Annex Figure A.1: Banks' official and adjusted G-SIB scores
********************************************************************************
cls
clear
use "$folder\data_RR_MASTER_public", replace
keep if always_mpg == 1
keep year bank id UBI gsib_score gsib_score_ofcl_NOCAP bank_type
drop if bank_type == ""
pwcorr gsib_score gsib_score_ofcl_NOCAP if bank_type == "Low ROA Non GSIB"
pwcorr gsib_score gsib_score_ofcl_NOCAP if bank_type == "High ROA Non GSIB"
pwcorr gsib_score gsib_score_ofcl_NOCAP if bank_type == "Low ROA GSIB"
pwcorr gsib_score gsib_score_ofcl_NOCAP if bank_type == "High ROA GSIB"
collapse (mean) gsib_score gsib_score_ofcl_NOCAP, by(bank_type year)

twoway ///
line gsib_score year if bank_type == "Low ROA Non GSIB", xline(2015, lcolor(red)) lwidth(*3) yaxis(1) lcolor(cyan) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score_ofcl_NOCAP year if bank_type == "Low ROA Non GSIB", yaxis(1)  lcolor(cyan) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score year if bank_type == "High ROA Non GSIB", yaxis(1) lcolor(navy) lwidth(*3) lpattern(dash_dot) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score_ofcl_NOCAP year if bank_type == "High ROA Non GSIB", yaxis(1)  lcolor(navy) lpattern(dash_dot) yscale(range(40 180) axis(1)) ylabel(40 60 80 100 120 140 160 180, axis(1)) ytitle("", axis(1)) || ///
line gsib_score year if bank_type == "High ROA GSIB", lcolor(cranberry) lwidth(*3) lpattern(dash)  yaxis(2) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2)) || ///
line gsib_score_ofcl_NOCAP year if bank_type == "High ROA GSIB", lcolor(cranberry)  yaxis(2) lpattern(dash) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2)) || ///
line gsib_score year if bank_type == "Low ROA GSIB", lcolor(sand) lwidth(*4) lpattern(dot)  yaxis(2) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2))  || ///
line gsib_score_ofcl_NOCAP year if bank_type == "Low ROA GSIB", lcolor(sand) lwidth(*2) lpattern(dot) yaxis(2) yscale(range(150 290) axis(2)) ylabel(150 170 190 210 230 250 270 290, axis(2)) ytitle("", axis(2))  ///
legend(order(5 "High ROA G-SIBs (rhs)" 7 "Low ROA G-SIBs (rhs)" 1 "Low ROA Non G-SIBs (lhs)" 3 "High ROA Non G-SIBs (lhs)" ) symxsize(*1) rows(4) pos(3) colgap(20) region(lcolor(white)) size(4)) ///
graphregion(color(white)) ysize(2.5) xsize(6) xtitle("") ytitle(Average score: Non G-SIBs, height(8) axis(1) size(4)) ///
ytitle(Average score: G-SIBs, height(10) axis(2) size(4)) ///
text(100 2013.7 "Pre-treatment", color(black) size(4)) ///
text(90 2013.4 "period", color(black) size(4)) name(group_simple_avg_ofcl, replace)
graph export "$folder\exhibits\Annex_Figure_A1_gsib_score_adj.jpg", replace
graph export "$folder\exhibits\Annex_Figure_A1_gsib_score_adj.pdf", replace

********************************************************************************
** Annex Table C.1: Mean difference of co-variates before and after matching.
********************************************************************************

clear
use "$folder\data_RR_MASTER_public", replace

**compare pre-treatment averages of controls used for matching
xtset id year
drop if post==1

collapse (mean) $mtch_prd gsib_pre , by(id) 

**create Excel file 
capture erase "$folder\exhibits\Annex_Table_A1_match_balance.xlsx" 
putexcel set  "$folder\exhibits\Annex_Table_A1_match_balance.xlsx" 

putexcel A1 = "Bank control"
putexcel A2 = "CET1 buffer"
putexcel A3 = "Leverage ratio buffer"
putexcel A4 = "NPL ratio"
putexcel A5 = "Cash to total assets"
putexcel A6 = "Deposits to total liabilities"
putexcel A7 = "Density ratio"
putexcel A8 = "TLAC proxy"
putexcel A9 = "Return on assets"

putexcel C1 = "G-SIBs"
putexcel E1 = "Non G-SIBs"
putexcel G1 = "p-value (unmatched)"
putexcel I1 = "p-value (match 1)"
putexcel K1 = "p-value (match 2)"

putexcel B1:B9 = "&"
putexcel D1:D9 = "&"
putexcel F1:F9 = "&"
putexcel H1:H9 = "&"
putexcel J1:J9 = "&"
putexcel L1:L9 = "\\"

qui {
local index=1
foreach v of varlist $mtch_prd {
local `index++'
**perform t-test and save the results
ttest `v' , by(gsib_pre) unequal 	
**GSIB mean
putexcel C`index' = (round(r(mu_2),.01))
**Non GSIB mean
putexcel E`index' = (round(r(mu_1),.01))
**p-value of test
putexcel G`index' = (round(r(p),.01))
}
}

****************************************************************************
use "$folder\temp\data_matching", replace

qui {
drop if post==1
* match based on controls used in the baseline DD -- use average value of controls in the pre-treatment period
collapse (mean) $mtch_prd gsib_pre ROA_med weight1 weight2, by(id) 

* matching covariates - pre-treatment average & standardize for matching
foreach v of varlist $mtch_prd {
egen `v'_st = std(`v')
drop  `v'
rename `v'_st `v'
}

**Matching method 1
local index=1
foreach v of varlist $mtch_prd {
local `index++'
svyset `v' [pweight= weight1]
svy: mean `v' , over(gsib_pre) 
**perform t-test and save the results
lincom _b[`v'#1.gsib_pre] - _b[`v'#0.gsib_pre]
**p-value of test
putexcel I`index' = (round(r(p),.01))
}
}

********************************************************************************
putexcel K2 = $pv_cet1_buffer
putexcel K3 = $pv_lr_buffer  
putexcel K4 = $pv_NPL_ratio  
putexcel K5 = $pv_CSH_to_A   
putexcel K6 = $pv_DEP_to_L   
putexcel K7 = $pv_density    
putexcel K8 = $pv_TLAC       
putexcel K9 = $pv_ROA    
